# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' A C++ function to quantify sgRNA abundance from NGS samples.
#'
#' @param ref_path the path of the annotation file and it has to be a FASTA formatted file.
#' @param fastq_path a list of the FASTQ files.
#'
#' @importFrom Rcpp evalCpp
#' @useDynLib CB2
#' @export
quant <- function(ref_path, fastq_path) {
    .Call('_CB2_quant', PACKAGE = 'CB2', ref_path, fastq_path)
}

#' A C++ function to perform a parameter estimation for the sgRNA-level test. 
#' It will estimate two different parameters `phat` and `vhat,`
#' and we assume input count data follows the beta-binomial distribution.
#' Dr. Keith Baggerly initially implemented this code in Matlab,
#' and it has been rewritten it in C++ for the speed-up.
#' 
#' @param xvec a matrix contains sgRNA read counts.
#' @param nvec a vector contains the library size.
#' 
#' @importFrom Rcpp evalCpp
#' @useDynLib CB2
#' @export
fit_ab <- function(xvec, nvec) {
    .Call('_CB2_fit_ab', PACKAGE = 'CB2', xvec, nvec)
}

