% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{run_estimation}
\alias{run_estimation}
\title{A function to perform a statistical test at a sgRNA-level}
\usage{
run_estimation(sgcount, design, group_a, group_b)
}
\arguments{
\item{sgcount}{A table contains}

\item{design}{A table contains study design. It has to contain `group`}

\item{group_a}{The first group to be in the test.}

\item{group_b}{The second group to be in the test.}
}
\value{
a table contains the sgRNA-level test result, and the table contains these columns: 
\itemize{
 \item `sgRNA`: The sgRNA identifier.
 \item `gene`: The gene is the target of the sgRNA 
 \item `n_a`: The number of replicates of the first group.
 \item `n_b`: The number of replicates of the second group.
 \item `phat_a`: The proportion value of the sgRNA for the first group.
 \item `phat_b`: The proportion value of the sgRNA for the second group.
 \item `vhat_a`: The variance of the sgRNA for the first group.
 \item `vhat_b`: The variance of the sgRNA for the second group.
 \item `cpm_a`: The mean CPM of the sgRNA within the first group.
 \item `cpm_b`: The mean CPM of the sgRNA within the second group.
 \item `logFC`: The log fold change of sgRNA between two groups.
 \item `t_value`: The value for the t-statistics.
 \item `df`: The value of the degree of freedom, and will be used to calculate the p-value of the sgRNA.
 \item `p_ts`: The p-value indicates a difference between the two groups.
 \item `p_pa`: The p-value indicates enrichment of the first group.
 \item `p_pb`: The p-value indicates enrichment of the second group.
 \item `fdr_ts`: The adjusted P-value of `p_ts`.
 \item `fdr_pa`: The adjusted P-value of `p_pa`.
 \item `fdr_pb`: The adjusted P-value of `p_pb`.
}
}
\description{
A function to perform a statistical test at a sgRNA-level
}
\examples{
library(CB2)
data(Evers_CRISPRn_RT112)
run_estimation(Evers_CRISPRn_RT112$count, Evers_CRISPRn_RT112$design, "before", "after")

}
