% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_mappability}
\alias{calc_mappability}
\title{A function to calculate mappability of each NGS sample.}
\usage{
calc_mappability(count_obj, df_design)
}
\arguments{
\item{count_obj}{A list object is generated by `run_sgrna_quant`}

\item{df_design}{The table contains a study design.}
}
\description{
A function to calculate mappability of each NGS sample.
}
\examples{
library(CB2)
library(magrittr)
library(tibble)
library(dplyr)
library(glue)
FASTA <- system.file("extdata", "toydata", "small_sample.fasta", package = "CB2")
ex_path <- system.file("extdata", "toydata", package = "CB2")

df_design <- tribble(
  ~group, ~sample_name,
  "Base", "Base1",  
  "Base", "Base2", 
  "High", "High1",
  "High", "High2") \%>\% 
    mutate(fastq_path = glue("{ex_path}/{sample_name}.fastq"))

cb2_count <- run_sgrna_quant(FASTA, df_design)
calc_mappability(cb2_count, df_design)

}
