% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_dim_perm_scree.R
\name{sig.dim.perm.scree}
\alias{sig.dim.perm.scree}
\title{Scree plot to test the significance of CA dimensions by means of a randomized
procedure}
\usage{
sig.dim.perm.scree(data, B = 1000, cex = 0.7, pos = 4, offset = 0.5)
}
\arguments{
\item{data}{Name of the contingency table (must be in dataframe format).}

\item{B}{Number of permutations to be used (1000 by default).}

\item{cex}{Controls the size of the labels reporting the p values; see the
help documentation of the text() function by typing ?text.}

\item{pos}{Controls the position of the labels reporting the p values; see
the help documentation of the text() function by typing ?text.}

\item{offset}{Controls the offset of the labels reporting the p values; see
the help documentation of the text() function by typing ?text.}
}
\description{
This function allows to test the significance of the CA dimensions by means
of permutation of the input contingency table. Number of permutation set at
1000 by default, but can be increased by the user. The function return a
scree-plot displaying for each dimension the observed eigenvalue and the 95th
percentile of the permuted distribution of the corresponding eigenvalue.
Observed eigenvalues that are larger than the corresponding 95th percentile
are significant at least at alpha 0.05. P values are displayed into the
chart.
}
\examples{
data(greenacre_data)

sig.dim.perm.scree(greenacre_data, 1000)

}
\seealso{
\code{\link{sig.dim.perm}}
}
\keyword{sig.dim.perm.scree}
