% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cols_cntr_scatter.R
\name{cols.cntr.scatter}
\alias{cols.cntr.scatter}
\title{Scatterplot for column categories contribution to dimensions}
\usage{
cols.cntr.scatter(data, x = 1, y = 2, filter = FALSE, cex.labls = 3)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{First dimension for which the contributions are reported (x=1 by
default).}

\item{y}{Second dimension for which the contributions are reported (y=2 by
default).}

\item{filter}{Filter the categories in order to only display those who have a
major contribution to the definition of the selected dimensions.}

\item{cex.labls}{Adjust the size of the categories' labels}
}
\description{
This function allows to plot a scatterplot of the contribution of column
categories to two selected dimensions. Two references lines (in RED) indicate
the threshold above which the contribution can be considered important for
the determination of the dimensions. A diagonal line is a visual aid to
eyeball whether a category is actually contributing more (in relative terms)
to either of the two dimensions. The column categories' labels are coupled
with + or - symbols within round brackets indicating which to side of the two
selected dimensions the contribution values that can be read off from the
chart are actually referring. The first symbol (i.e., the one to the left),
either + or -, refers to the first of the selected dimensions (i.e., the one
reported on the x-axis). The second symbol (i.e., the one to the right)
refers to the second of the selected dimensions (i.e., the one reported on
the y-axis).
}
\examples{
data(greenacre_data)

#Plots the scatterplot of the column categories contribution to dimensions 1&2.
cols.cntr.scatter(greenacre_data,1,2)

}
\seealso{
\code{\link{cols.cntr}} , \code{\link{rows.cntr}} , \code{\link{rows.cntr.scatter}}
}
\keyword{cols.cntr.scatter}
