% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{make_numeric_sets}
\alias{make_numeric_sets}
\title{Transforming the set of predictors into a numeric set}
\usage{
make_numeric_sets(a,ai,k,vari,ra,l)
}
\arguments{
\item{a}{An M x N matrix, containing all possible subsets (N overall) of the size M of predictors' indices; therefore each column of \code{a} defines a unique subset of the predictors}

\item{ai}{array of indices of the array \code{a}}

\item{k}{index of the array \code{ai}}

\item{vari}{set of all predictors}

\item{ra}{array of sample indices of \code{vari}}

\item{l}{size of the sample}
}
\value{
Returns a list containing two objects: \code{tr} and \code{test}\cr
\item{tr}{training set transformed into a numeric one} 
\item{test}{test set transformed into a numeric one}
}
\description{
Function which turns a set of predictors containing non-numeric variables into a fully numeric set
}
\details{
Function transforms the whole set of predictors into a numeric set by consecutively calling function \code{make_numeric} for each predictor
}
\examples{
#creating a categorical numeric variable

a<-t(rmultinom(100,1,c(0.2,0.3,0.5)))\%*\%c(1,2,3)

#creating an analogous non-numeric variable 

c<-array(NA,100)
c[a==1]='red'
c[a==2]='green'
c[a==3]='blue'

#creating a data-set

b<-data.frame(matrix(c(a,rbinom(100,1,0.3),runif(100,0,1)),ncol=3))

#making the first column of the data-set non-numeric

b[,1]=data.frame(c)

#running the function

make_numeric_sets(combn(3,2),1:3,1,b,sample(1:100,60),100)
}
\seealso{
\code{\link{make_numeric}}
}
