% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.btfit.R
\name{simulate_BT}
\alias{simulate_BT}
\alias{simulate.btfit}
\title{This function simulates one or more pseudo-random datasets from a specified
Bradley-Terry model.  Counts are simulated from independent binomial
distributions, with the binomial probabilities and totals specified
through the function arguments.}
\usage{
simulate_BT(pi, N, nsim = 1, seed = NULL, result_class = c("sparseMatrix",
  "btdata"))

\method{simulate}{btfit}(object, nsim = 1, seed = NULL,
  result_class = c("sparseMatrix", "btdata"), ...)
}
\arguments{
\item{pi}{a numeric vector, with all values finite and positive.  The vector
of item strengths in the Bradley-Terry model.}

\item{N}{a symmetric, numeric matrix with dimensions the same as
\code{length(pi)}.  The elements should
be numeric representations of non-negative integers.  These are the
binomial totals to use for the simulated data.}

\item{nsim}{a scalar integer, the number of datasets to be generated.}

\item{seed}{an object specifying if and how the random number generator
should be initialized (‘seeded’).
For details see \code{\link[stats]{simulate}}.}

\item{result_class}{a character vector specifying whether the generated
datasets should be of class
"sparseMatrix" or of class "btdata".  If not specified, the first match among
those alternatives is used.}

\item{object}{An object of class "btfit", typically the result of \code{ob} of \code{ob <- btfit(..)}. This object must only have one component, i.e. \code{length(object$pi) == 1}.}

\item{...}{Other arguments}
}
\value{
a list of length \code{nsim} of simulated datasets.
If \code{result_class = "sparseMatrix"}, the datasets are sparse matrices
with the same dimensions as \code{N}. If \code{result_class = "btdata"} then
the datasets are "btdata" objects. See \code{\link{btdata}}
}
\description{
This function simulates one or more pseudo-random datasets from a specified
Bradley-Terry model.  Counts are simulated from independent binomial
distributions, with the binomial probabilities and totals specified
through the function arguments.
}
\examples{
set.seed(1)
n <- 6
N <- matrix(rpois(n ^ 2, lambda = 1), n, n)
N <- N + t(N) ; diag(N) <- 0
p <- exp(rnorm(n)/4)
names(p) <- rownames(N) <- colnames(N) <- letters[1:6]
simulate_BT(p, N, seed = 6)
citations_btdata <- btdata(BradleyTerryScalable::citations)
fit1 <- btfit(citations_btdata, 1)
simulate(fit1, nsim = 2, seed = 1)
toy_df_4col <- codes_to_counts(BradleyTerryScalable::toy_data, c("W1", "W2", "D"))
toy_btdata <- btdata(toy_df_4col)
fit2 <- btfit(toy_btdata, 1, subset = function(x) "Amy" \%in\% x)
fit2_sim <- simulate(fit2, nsim = 3, result_class = "btdata")
fit2_sim$sim_1
purrr::map(fit2_sim, "wins")

}
\seealso{
\code{\link{btfit}}, \code{\link{btdata}}
}
\author{
David Firth
}
