% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/706-checkProt.R
\name{checkProt}
\alias{checkProt}
\title{Check if the protein sequence's amino acid types are the 20 default types}
\usage{
checkProt(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
Logical. \code{TRUE} if all of the amino acid types of the sequence
        are within the 20 default types.
}
\description{
Check if the protein sequence's amino acid types are the 20 default types
}
\details{
This function checks if the protein sequence's amino acid types are 
the 20 default types.
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
checkProt(x)  # TRUE
checkProt(paste(x, 'Z', sep = ''))  # FALSE

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{acid}
\keyword{amino}
\keyword{check}
\keyword{protein}
\keyword{sequence}
\keyword{type}
