% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.bess.R
\name{coef.bess}
\alias{coef.bess}
\title{Provides estimated coefficients from a fitted "bess" object.}
\usage{
\method{coef}{bess}(object, sparse = TRUE, ...)
}
\arguments{
\item{object}{A "\code{bess}" project.}

\item{sparse}{Logical or NULL, specifying whether the coefficients should be
presented as sparse matrix or not.}

\item{\dots}{Other arguments.}
}
\description{
This function provides estimated
coefficients from a fitted "\code{bess}" object.
}
\examples{

# Generate simulated data
n <- 200
p <- 20
k <- 5
rho <- 0.4
seed <- 10
Tbeta <- rep(0, p)
Tbeta[1:k*floor(p/k):floor(p/k)] <- rep(1, k)
Data <- gen.data(n, p, k, rho, family = "gaussian", beta = Tbeta, seed = seed)
lm.bss <- bess(Data$x, Data$y, method = "sequential")
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
lm.bsrr <- bess(Data$x, Data$y, type = "bsrr", method = "pgsection")
coef(lm.bss)
coef(lm.bsrr)
}
\references{
Wen, C., Zhang, A., Quan, S. and Wang, X. (2020). BeSS: An R
Package for Best Subset Selection in Linear, Logistic and Cox Proportional
Hazards Models, \emph{Journal of Statistical Software}, Vol. 94(4).
doi:10.18637/jss.v094.i04.
}
\seealso{
\code{\link{bess}}, \code{\link{print.bess}}.
}
\author{
Canhong Wen, Aijun Zhang, Shijie Quan, Liyuan Hu, Kangkang Jiang, Yanhang Zhang, Jin Zhu and Xueqin Wang.
}
