% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarginals.R
\name{marginalPlot}
\alias{marginalPlot}
\title{Plot MCMC marginals}
\usage{
marginalPlot(mat, thin = "auto", scale = NULL, best = NULL, ...)
}
\arguments{
\item{mat}{object of class "bayesianOutput" or a matrix or data frame of variables}

\item{thin}{thinning of the matrix to make things faster. Default is to thin to 5000}

\item{scale}{should the results be scaled. Value can be either NULL (no scaling), T, or a matrix with upper / lower bounds as columns. If set to T, attempts to retrieve the scaling from the input object mat (requires that this is of class BayesianOutput)}

\item{best}{if provided, will draw points at the given values (to display true / default parameter values). Value can be either NULL (no drawing), a vector with values, or T, in which case the function will attempt to retrieve the values from a BayesianOutput}

\item{...}{additional parameters to pass on to the \code{\link{getSample}}}
}
\description{
Plot MCMC marginals
}
\examples{
dat = generateTestDensityMultiNormal(n = 100000, sample = TRUE)
marginalPlot(dat(10000))
}
\seealso{
\code{\link{plotTimeSeries}} \cr
         \code{\link{tracePlot}} \cr
         \code{\link{correlationPlot}}
}
\author{
Florian Hartig
}
