% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOPboxes.r
\name{TOPboxes}
\alias{TOPboxes}
\title{Calculate Team, Opponents and Players box scores (Tbox, Obox and Pbox)}
\usage{
TOPboxes(data, team)
}
\arguments{
\item{data}{a data frame containing play-by-play data (see Details)}

\item{team}{character, indicating the name of the team}
}
\value{
A list with the following elements

\itemize{
\item \code{Tbox}, the data frame of team box scores
}

\itemize{
\item \code{Obox}, the data frame of opponents box scores
}

\itemize{
\item \code{Pbox}, the data frame of player box scores
}
}
\description{
Calculate Team, Opponents and Players box scores (Tbox, Obox and Pbox)
}
\details{
To compute \code{Tbox} and \code{Obox}, the function needs the following variables:
\code{game_id}, \code{playlength}, \code{ShotType}, \code{points}, \code{result}, \code{team}, \code{oreb}, \code{dreb}, \code{PF}, \code{turnover}, \code{assist}, \code{block} and \code{steal}.
If any of these variables is missing, an error message is displayed.

To compute \code{Pbox}, also the variables player, \code{a1} . . . \code{a5}, \code{h1} . . . \code{h5} and \code{hometeam} are needed.
If any is omitted, only \code{Tbox} and \code{Obox} are given in output.

Note that the variables \code{assist}, \code{block} and \code{steal} can contain the logical indicator of whether the corresponding event has occurred (TRUE/FALSE or numerical 0/1) or the name of the involved player (character).
In the former case, \code{Tbox} and \code{Obox} are fully computed, while the variables \code{AST}, \code{BLK} and \code{STL} are missing in the \code{Pbox} data frame.
In the latter case, all the data frames \code{Tbox}, \code{Obox} and \code{Pbox} are fully computed.

\code{TOPboxes} omits the computation of the variables \code{W} (Games won) and \code{L} (Games lost).
In fact, since we aim at computing box scores starting from whatever portion of play-by-play data (e.g., only a part of a game), in some cases, calculating the number of won and lost games does not make sense.
}
\examples{
library(operators)
library(dplyr)
PbP <- PbPmanipulation(PbP.BDB)
PbP <- PbP \%>\%
  mutate(oreb = type \%~\% "rebound offensive",
         dreb = type \%~\% "rebound defensive",
                turnover = event_type=="turnover",
                PF = (event_type == "foul") & !(type \%~\% "technical") ) \%>\%
        mutate(across(c(player, assist, steal, block, h1:h5, a1:a5), as.character)) \%>\%
 as.data.frame()
out <- TOPboxes(PbP, team="GSW")
}
\references{
P. Zuccolotto, M. Manisera and M. Sandri (2026) Advanced Basketball Data Science: With Applications in R. CRC Press.

P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{PbPmanipulation}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
