% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.Regression-method}
\alias{predict,est.Regression-method}
\title{Prediction for a regression model}
\usage{
\S4method{predict}{est.Regression}(object, t, only.interval = TRUE,
  level = 0.05, burnIn, thinning, fun.mat, which.series = c("new",
  "current"), M2pred = 10, cand.length = 1000, method = c("vector",
  "free"), sampling.alg = c("InvMethod", "RejSamp"), sample.length, grid,
  plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.Regression", created with method \code{\link{estimate,Regression-method}}}

\item{t}{vector of time points to make predictions for}

\item{only.interval}{if TRUE: only calculation of prediction intervals}

\item{level}{level of the prediction intervals}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{fun.mat}{matrix-wise definition of drift function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector")}

\item{method}{vectorial ("vector") or not ("free")}

\item{sampling.alg}{sampling algorithm, inversion method ("InvMethod") or rejection sampling ("RejSamp")}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{grid}{fineness degree of sampling approximation}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of regression model
  \eqn{y_i = f(\phi, t_i) + \epsilon_i, \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t_i))}.
}
\examples{
t <- seq(0,1, by = 0.01)
cl <- set.to.class("Regression", fun = function(phi, t) phi[1]*t + phi[2],
                   parameter = list(phi = c(1,2), gamma2 = 0.1))
data <- simulate(cl, t = t)
est <- estimate(cl, t, data, 1000)
plot(est)
pred <- predict(est, fun.mat = function(phi, t) phi[,1]*t + phi[,2])
\dontrun{
pred2 <- predict(est, fun.mat = function(phi, t) phi[,1]*t + phi[,2], only.interval = FALSE)
plot(density(pred2[,10]))
}
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

