% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barmorc.R
\name{bamorc}
\alias{bamorc}
\title{Calculates the referencing correction value.}
\usage{
bamorc(sequence, secondary_structure = NULL, chemical_shifts_input,
  from = -5, to = 5)
}
\arguments{
\item{sequence}{string of sequence}

\item{secondary_structure}{string of secondary structure (optional)}

\item{chemical_shifts_input}{table of alpha and beta carbon chemical shift pairs in data.frame}

\item{from}{the lower bound of the optimization search window}

\item{to}{the upper bound of the optimization search window}
}
\value{
Carbon-13 reference correction value that should be applied (added) to the input carbon chemical shifts data.
}
\description{
The core package function that calculates the carbon-13 reference correction using an input protein sequence with associated secondary structure information along with a table of alpha and beta carbon chemical shift  pairs. The output of this function is the correction value that should be added to the input carbon chemical shifts.
}
\examples{
sequence <- paste(RefDB_data$carbonDat[[1]]$AA,collapse = "")
secondary_structure <- paste(RefDB_data$carbonDat[[1]]$SS,collapse = "")
chemical_shifts_input <- RefDB_data$carbonDat[[1]][,c(4,5)]
from=-5
to=5

\dontrun{bamorc(sequence, secondary_structure, chemical_shifts_input, from=-5, to=5)}

# Expected output
# [1] 0.0142443


sequence <- paste(BaMORC::RefDB_data$carbonDat[[1]]$AA,collapse = "")
chemical_shifts_input <- BaMORC::RefDB_data$carbonDat[[1]][,c(4,5)]
from=-5
to=5


\dontrun{bamorc(sequence=sequence, chemical_shifts_input=chemical_shifts_input, from=-5, to=5)}
# Expected output
# [1] 0.009805279
}
