% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{read_raw_file}
\alias{read_raw_file}
\title{Extracts data from a protein NMR experimental peak list.
\code{read_raw_file()} function reads in a user provided protein NMR experimental peak list. It currently supports file format in csv, txt with deliminator of comma, whitespace or semicolon.
Note: please don't leave space between sequence and chemical shifts data, otherwise it will report error.}
\usage{
read_raw_file(file_path, delim = "comma", assigned = FALSE)
}
\arguments{
\item{file_path}{File path where input chemical shifts file is located}

\item{delim}{Delimiter for parsing file}

\item{assigned}{Flag tell whether the input chemical shifts file is already assigned or not}
}
\value{
A list contains protein sequence and chemical shift table.
}
\description{
Extracts data from a protein NMR experimental peak list.
\code{read_raw_file()} function reads in a user provided protein NMR experimental peak list. It currently supports file format in csv, txt with deliminator of comma, whitespace or semicolon.
Note: please don't leave space between sequence and chemical shifts data, otherwise it will report error.
}
\examples{
input_type = "ws" 
sample_file_path = system.file("extdata", "sample_input_ws.txt", package = "BaMORC")
head(read_raw_file(file_path=sample_file_path, delim="ws"))

input_type = "csv"
sample_file_path = system.file("extdata", "sample_input.csv", package = "BaMORC")
head(read_raw_file(file_path=sample_file_path, delim="comma"))
unlink("sample_input.csv")

input_type = "sc"
sample_file_path = system.file("extdata", "sample_input_sc.txt", package = "BaMORC")
head(read_raw_file(file_path=sample_file_path, delim="semicolon"))
unlink("sample_input_sc.txt")

}
