% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barmorc.R
\name{calculate_rcf}
\alias{calculate_rcf}
\title{Calculates the relative cumulative frequency for amino acid and secondary structure.}
\usage{
calculate_rcf(sequence, secondary_structure)
}
\arguments{
\item{sequence}{String of protein sequence with one letter convention}

\item{secondary_structure}{String of protein secondary structure with single letter convention}
}
\value{
Relative cumulative frequency.
}
\description{
This function calculates the relative cumulative frequency of amino acid and secondary structure combination.
}
\examples{
sequence = paste(RefDB_data$carbonDat[[1]]$AA, collapse = "")
secondary_structure = paste(RefDB_data$carbonDat[[1]]$SS, collapse = "")
relativeCumulativeFrequency = calculate_rcf(sequence, secondary_structure)
}
