% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Quail}
\alias{Quail}
\title{Plasma LDL levels in two groups of quail}
\format{
A data frame/tibble with 40 observations on two variables
\describe{ 
\item{group}{a character variable with values \code{placebo} and \code{treatment}}
\item{level}{low-density lipoprotein (LDL) cholestrol level} 
}
}
\source{
J. McKean, and T. Vidmar (1994), "A Comparison of Two Rank-Based Methods for the
Analysis of Linear Models," \emph{The American Statistician, 48}, 220-229.
}
\usage{
Quail
}
\description{
Data for Exercise 1.53, 1.77, 1.88, 5.66, and 7.50
}
\examples{

boxplot(level ~ group, data = Quail, horizontal = TRUE, xlab = "LDL Level",
        col = c("yellow", "lightblue"))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
