% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Toxic}
\alias{Toxic}
\title{Hazardous waste sites near minority communities}
\format{A data frame/tibble with 51 observations on five variables
\describe{ 
\item{state}{U.S. state}
\item{region}{U.S. region} 
\item{sites}{number of commercial hazardous waste sites}
\item{minority}{percent of minorities living in communities with commercial hazardous waste sites} 
\item{percent}{a numeric vector} 
}}
\usage{
Toxic
}
\description{
Data for Exercises 1.55, 5.08, 5.109, 8.58, and 10.35
}
\examples{

hist(Toxic$sites, col = "red")
hist(Toxic$minority, col = "blue")
qqnorm(Toxic$minority)
qqline(Toxic$minority)
boxplot(sites ~ region, data = Toxic, col = "lightgreen")
tapply(Toxic$sites, Toxic$region, median)
kruskal.test(sites ~ factor(region), data = Toxic)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
