% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Sat}
\alias{Sat}
\title{SAT scores, percent taking exam and state funding per student by state for
1994, 1995 and 1999}
\format{A data frame/tibble with 102 observations on seven variables
\describe{ 
\item{state}{U.S. state}
\item{verbal}{verbal SAT score} 
\item{math}{math SAT score} 
\item{total}{combined verbal and math SAT score} 
\item{percent}{percent of high school seniors taking the SAT} 
\item{expend}{state expenditure per student (in dollars)} 
\item{year}{year} 
}}
\source{
\emph{The 2000 World Almanac and Book of Facts}, Funk and Wagnalls Corporation, New Jersey.
}
\usage{
Sat
}
\description{
Data for Statistical Insight Chapter 9
}
\examples{

Sat94 <- Sat[Sat$year == 1994, ]
Sat94
Sat99 <- subset(Sat, year == 1999)
Sat99
stem(Sat99$total)
plot(total ~ percent, data = Sat99)
model <- lm(total ~ percent, data = Sat99)
abline(model, col = "blue")
summary(model)
rm(model)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
