% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFormula.R
\name{createFormula}
\alias{createFormula}
\title{Create a formula with interactions and polynomials up to a desired order}
\usage{
createFormula(formula, maxExponent = 1, interactionDepth = 1,
  intercept = TRUE)
}
\arguments{
\item{formula}{formula object: formula object without exponents or
interactions. If \code{formula} is not of class \code{formula}, it is turned
into one.}

\item{maxExponent}{positive integer: highest exponent included in the
formula. Default is 1, e.g., only linear effects.}

\item{interactionDepth}{positive integer: maximum order of interaction.
Default is 1, e.g., only main effects (no interactions).}

\item{intercept}{logical: include intercept or not?}
}
\value{
A formula containing the original independent variables and their
polynomials and interactions.
}
\description{
Creates a formula with interactions and polynomials up to a
desired order. If the input \code{formula} already includes interactions,
exponents or other functions (e.g., \code{\link[base]{sqrt}}), they are
ignored.
}
\examples{
createFormula("y ~ x1 + x2", 2, 3)
createFormula(as.formula("y ~ x1 + x2"), interactionDepth = 2)

carFormula <- createFormula("mpg ~ cyl + disp + drat", 2, 3)
summary(lm(carFormula, mtcars))
}
