% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{optim.boxcox}
\alias{optim.boxcox}
\title{Find optimal Box-Cox transformation parameters}
\usage{
optim.boxcox(value, fac, shift = FALSE)
}
\arguments{
\item{value}{Response variable in the data, e.g. \code{"effect"} column}

\item{fac}{Factor indicating groups of replicates, e.g.
\code{interaction(d1,d2)}}

\item{shift}{Whether to use 2-parameter Box-Cox transformation. Input may be
\code{TRUE/FALSE} or a numeric value indicating the shift parameter to use.
If \code{FALSE}, shift parameter is set to zero.}
}
\value{
Numeric vector with power and shift parameter in that order.
}
\description{
Find optimal Box-Cox transformation parameters
}
\examples{
  data <- subset(directAntivirals, experiment == 1)
  optim.boxcox(data$effect, interaction(data$d1, data$d2))
}
