% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_sim.R
\name{bekk_sim}
\alias{bekk_sim}
\title{Simulating BEKK models}
\usage{
bekk_sim(spec, nobs)
}
\arguments{
\item{spec}{A spec object of class "bekkSpec" from the function \link{bekk_spec} or a fitted bekk model of class "bekkFit" from the \link{bekk_fit} function}

\item{nobs}{Number of observations of the simulated sample}
}
\value{
Returns a simulated time series S3 class object using the parameters of passed "bekkSpec" or "bekkFit".
}
\description{
Method for simulating a N-dimensional BEKK model.
}
\examples{
\donttest{

# Simulate a BEKK with estimated parameter
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds)

x2 <- bekk_sim(x1, 3000)

plot(x2)

}

}
