% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{log_loss}
\alias{log_loss}
\title{Calculating the log-loss incurred in prediction}
\usage{
log_loss(input_data, depth, train_size, beta = NULL)
}
\arguments{
\item{input_data}{the sequence to be analysed. 
The sequence needs to be a "character" object. See the examples section of BCT/kBCT functions on how to transform any dataset to a "character" object.}

\item{depth}{maximum memory length.}

\item{train_size}{number of samples used in the training set. The training set size should be at least equal to the depth.}

\item{beta}{hyper-parameter of the model prior. 
Takes values between 0 and 1. If not initialised in the call function, the default value is \ifelse{html}{\out{1-2<sup>-m+1</sup>}}{\eqn{1 - 2^{-m+1}}}, 
where \ifelse{html}{\out{m}}{\eqn{m}} is the size of the alphabet; for more information see \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al. (2020)}.}
}
\value{
returns a vector containing the averaged log-loss incurred in the sequential prediction at each time-step.
}
\description{
Compute the log-loss incurred in BCT prediction with memory length D. Given an initial context
\ifelse{html}{\out{(x<sub>-D+1</sub>, ..., x<sub>0</sub>)}}{\eqn{(x_{-D+1},...,x_0)}} and training data \ifelse{html}{\out{(x<sub>1</sub>, ..., x<sub>n</sub>)}}{(\eqn{x_{1},...,x_n)}}, the log-loss is computed in sequentially predicting
the test data \ifelse{html}{\out{(x<sub>n+1</sub>, ..., x<sub>n+T</sub>)}}{\eqn{(x_{n+1},...,x_{n+T})}}. The function outputs the cummulative, normalized (per-sample) log-loss, at each prediction step; for more information see \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al.(2020)}.
}
\examples{
# Compute the log-loss in the prediction of the last 10 elements 
# of a dataset. 
log_loss(pewee, 5, nchar(pewee) - 10)

# For custom beta (e.g. 0.7):
log_loss(pewee, 5, nchar(pewee) - 10, 0.7)
}
\seealso{
\code{\link{prediction}}, \code{\link{zero_one_loss}}
}
