% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MAP_parameters}
\alias{MAP_parameters}
\title{Parameters of the MAP model}
\usage{
MAP_parameters(input_data, depth, beta = NULL)
}
\arguments{
\item{input_data}{the sequence to be analysed. 
The sequence needs to be a "character" object. See the examples section of BCT/kBCT functions on how to transform any dataset to a "character" object.}

\item{depth}{maximum memory length.}

\item{beta}{hyper-parameter of the model prior. 
Takes values between 0 and 1. If not initialised in the call function, the default value is \ifelse{html}{\out{1-2<sup>-m+1</sup>}}{\eqn{1 - 2^{-m+1}}}, 
where \ifelse{html}{\out{m}}{\eqn{m}} is the size of the alphabet; for more information see \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al. (2020)}.}
}
\value{
list of parameters for each of the context within the MAP model.
}
\description{
Returns the parameters of each leaf contained in the MAP model.
}
\examples{

# Use the gene_s dataset:
q <- BCT(gene_s, 10)
expected_contexts <- q[['Contexts']]
expected_contexts
# [1] "3"  "1"  "0"  "23" "20" "21" "22"

# For default beta:
v <- MAP_parameters(gene_s, 10)

# For custom beta (e.g. 0.8):
MAP_parameters(gene_s, 10, 0.8)

# generate a sequence of data using the generate_data function
s <- generate_data(v, 20000)

# Use BCT:
r <- BCT(s, 10)

# Check the resulting contexts:
r[['Contexts']]
# [1] "3"  "0"  "1"  "20" "22" "23" "21"

# The resulting contexts are as expected 

}
\seealso{
\code{\link{BCT}}, \code{\link{kBCT}}, \code{\link{generate_data}}
}
