% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_scraping_games.R
\name{do_scraping_games}
\alias{do_scraping_games}
\title{Player game finder data}
\usage{
do_scraping_games(competition, type_league, nums, year, verbose, accents, r_user)
}
\arguments{
\item{competition}{String. Options are "ACB", "Euroleague" and "Eurocup".}

\item{type_league}{String. If \code{competition} is ACB, to scrape 
ACB league games ("ACB"), Copa del Rey games ("CREY") or Supercopa games ("SCOPA").}

\item{nums}{Numbers corresponding to the website from which scraping.}

\item{year}{If \code{competition} is either Euroleague or Eurocup, the year
when the season starts is needed. 2017 refers to 2017-2018 and so on.}

\item{verbose}{Should R report information on progress? Default TRUE.}

\item{accents}{If \code{competition} is ACB, should we keep the Spanish accents? 
The recommended option is to remove them, so default FALSE.}

\item{r_user}{Email to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}
}
\value{
A data frame with the player game finder data for the competition selected.
}
\description{
This function calls the needed ancillary functions to scrape the player game 
finder data for the desired competition (currently, ACB, Euroleague and Eurocup).
}
\examples{
\dontrun{
# Not needed to scrape every time the package is checked, built and installed.
df1 <- do_scraping_games(competition = "ACB", type_league = "ACB", nums = 62001,
                         year = "2017-2018", verbose = TRUE, accents = FALSE, 
                         r_user = "guillermo.vinue@uv.es")
                         
df1_eur <- do_scraping_games(competition = "Euroleague", nums = 1,
                         year = "2017", verbose = TRUE,
                         r_user = "guillermo.vinue@uv.es")                          
}                          

}
\seealso{
\code{\link{scraping_games_acb}}, \code{\link{scraping_games_euro}}
}
\author{
Guillermo Vinue
}
