% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{raster.alpha}
\alias{raster.alpha}
\title{Maps of alpha diversity (Taxon, Phylogenetic or Functional Diversity - TD, PD, FD).}
\usage{
raster.alpha(layers, tree)
}
\arguments{
\item{layers}{A Raster* object of species distributions (typically a multi-layer type: RasterStack or RasterBrick).}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}
}
\value{
A raster object representing richness in space.
}
\description{
Observed alpha diversity using rasters of species distributions (presence/absence).
}
\details{
TD is equivalent to species richness. Calculations of PD and FD are based on Faith (1992) and Petchey & Gaston (2002, 2006), which measure PD and FD of a community as the total branch length of a tree linking all species represented in such community.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric). The path to the root of the tree is always included in calculations of PD and FD.
The number and order of species in layers must be the same as in tree.
}
\examples{
sp1 <- raster::raster(matrix(c(NA,1,1,1,1,0,0,0,0), nrow = 3, ncol = 3, byrow = TRUE))
sp2 <- raster::raster(matrix(c(0,0,0,0,1,1,1,1,1), nrow = 3, ncol = 3, byrow = TRUE))
sp3 <- raster::raster(matrix(c(0,0,0,1,1,1,0,0,0), nrow = 3, ncol = 3, byrow = TRUE))
spp <- raster::stack(sp1, sp2, sp3)
tree <- hclust(dist(c(1:3), method="euclidean"), method="average")
tree$labels = c("Sp1", "Sp2", "Sp3")
names(spp) = tree$labels
raster.alpha(spp)
raster.alpha(spp, tree)
}
\references{
Faith, D.P. (1992) Conservation evaluation and phylogenetic diversity. Biological Conservation, 61, 1-10.

Petchey, O.L. & Gaston, K.J. (2002) Functional diversity (FD), species richness and community composition. Ecology Letters, 5, 402-411.

Petchey, O.L. & Gaston, K.J. (2006) Functional diversity: back to basics and looking forward. Ecology Letters, 9, 741-758.
}
