% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hull.beta}
\alias{hull.beta}
\title{Beta diversity partitioning using convex hulls.}
\usage{
hull.beta(comm, trait, func = "jaccard", return.hull = FALSE)
}
\arguments{
\item{comm}{A list of "convhulln" objects or a sites x species matrix, with incidence data about the species in the community.}

\item{trait}{A matrix of traits for each species in comm (a species for each row and traits as columns). Must be provided only if 'comm' is a sites x species matrix.}

\item{func}{Partial match indicating whether the Jaccard or Soerensen family of beta diversity measures should be used.  If not specified, default is Jaccard.}

\item{return.hull}{Boolean indicating whether the convex hull objects used to calculate beta diversity should be returned (default is FALSE).}
}
\value{
Three pairwise distance matrices, one per each of the three beta diversity components. If return.hull is set to TRUE, the function also returns the list of convex hulls used to compute the distance matrices.
}
\description{
Pairwise beta diversity partitioning into replacement and net difference in amplitude components of convex hulls.
}
\details{
Computes a pairwise decomposition of the overall differentiation among kernel hypervolumes into two components: the replacement (shifts) of space between hypervolumes and net differences between the amount of space enclosed by each hypervolume.
The beta diversity measures used here follow the FD partitioning framework used for kernel density hypervolumes, where Btotal = Breplacement + Brichness. Beta diversity ranges from 0 (when hypervolumes are identical) to 1 (when hypervolumes are fully dissimilar).
See Carvalho & Cardoso (2020) and Mammola & Cardoso (2020) for the full formulas of beta diversity used here.
}
\examples{
comm <- rbind(c(1,1,1,1,1), c(1,1,1,1,1), c(0,0,1,1,1),c(0,0,1,1,1))
rownames(comm) = c("Community_1","Community_2","Community_3","Community_4")
colnames(comm) = c("Sp_1","Sp_2","Sp_3","Sp_4", "Sp_5")

trait <- cbind(c(2.2,4.4,6.1,8.3,3),c(0.5,1,0.5,0.4,4),c(0.7,1.2,0.5,0.4,5),c(0.7,2.2,0.5,0.3,6))
rownames(trait) = c("Sp_1","Sp_2","Sp_3","Sp_4","Sp_5")
colnames(trait) = c("Trait_1","Trait_2","Trait_3","Trait_4")

hull.beta(comm = comm, trait = trait, return.hull = FALSE)
}
\references{
Carvalho, J.C. & Cardoso, P. (2020) Decomposing the causes for niche differentiation between species using hypervolumes. Frontiers in Ecology and Evolution. https://doi.org/10.3389/fevo.2020.00243

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution. https://doi.org/10.1111/2041-210X.13424
}
