% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/BAT.R
\name{optim.alpha}
\alias{optim.alpha}
\title{Optimization of alpha diversity sampling protocols.}
\usage{
optim.alpha(comm, tree, methods, samples, runs = 1000)
}
\arguments{
\item{comm}{A samples x species x sites array, with either abundance or incidence data.}

\item{tree}{An hclust or phylo object (used only to optimize PD or FD sampling).}

\item{methods}{A vector specifying the method of each sample (length must be equal to nrow(comm))}

\item{samples}{A vector defining a base protocol from which to build upon (complementarity analysis) (length must be equal to number of methods).}

\item{runs}{Number of random permutations to be made to the sample order. Default is 1000.}
}
\value{
A matrix of samples x methods (values being optimum number of samples per method). The last column is the average alpha diversity value, rescaled to 0-1 if made for several sites, where 1 is the true diversity of each site.
}
\description{
Optimization of alpha diversity sampling protocols when different methods and multiple samples per method are available.
}
\details{
Often a combination of methods allows sampling maximum plot diversity with minimum effort, as it allows sampling different sub-communities, contrary to using single methods.
Cardoso (2009) proposed a way to optimize the number of samples per method when the target is to maximize sampled alpha diversity. It is applied here for TD, PD and FD, and for one or multiple sites simultaneously.
Phylogenetic (PD) and functional (FD) diversities are calculated based on an ultrametric tree (hclust or phylo object).
}
\examples{
comm1 <- matrix(c(1,1,0,2,4,0,0,1,2,0,0,3), nrow = 4, ncol = 3, byrow = TRUE)
comm2 <- matrix(c(2,2,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm <- array(c(comm1, comm2), c(4,3,2))
colnames(comm) <- c("Sp1","Sp2","Sp3")
methods <- c("Met1","Met2","Met2","Met3")
tree <- hclust(dist(c(1:3), method="euclidean"), method="average")
optim.alpha(comm,,methods)
optim.alpha(comm, tree, methods)
optim.alpha(comm,, methods = methods, samples = c(0,0,1), runs = 100)
}
\references{
Cardoso, P. (2009) Standardization and optimization of arthropod inventories - the case of Iberian spiders. Biodiversity and Conservation, 18, 3949-3962.
}

