% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify}
\alias{classify}
\title{Performs the classification methodology using complex network and
entropy theories}
\usage{
classify(
  mRNA,
  lncRNA,
  sncRNA = NULL,
  trainingResult,
  save_dataframe = NULL,
  save_model = NULL
)
}
\arguments{
\item{mRNA}{Directory where the file .FASTA lies with the mRNA sequences}

\item{lncRNA}{Directory where the file .FASTA lies with the lncRNA sequences}

\item{sncRNA}{Directory where the file .FASTA lies with the sncRNA sequences
(optional)}

\item{trainingResult}{The result of the training, (three or two matrices)}

\item{save_dataframe}{save when set, this parameter saves a .csv file with
the features in the current directory. No file is created by default.}

\item{save_model}{save when set, this parameter saves a .rds file with
the model in the current directory. No file is created by default.}
}
\value{
Results
}
\description{
Given three or two distinct data sets, one of mRNA, one
of lncRNA and one of sncRNA.
The classification of the data is done from the structure of the networks
formed by the sequences, that is filtered by an entropy methodology.
After this is done, the classification starts.
}
\examples{
library(BASiNETEntropy)
arqSeqMRNA <- system.file("extdata", "mRNA.fasta",package = "BASiNETEntropy")
arqSeqLNCRNA <- system.file("extdata", "ncRNA.fasta", package = "BASiNETEntropy")
load(system.file("extdata", "trainingResult.RData", package = "BASiNETEntropy"))
r_classify <- classify(mRNA=arqSeqMRNA, lncRNA=arqSeqLNCRNA, trainingResult = trainingResult)
}
\author{
Murilo Montanini Breve
}
