% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertiafunctions.R
\name{compute_feat_inertia}
\alias{compute_feat_inertia}
\title{Compute the inertia of the individual feathers}
\usage{
compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
}
\arguments{
\item{dat_mat}{Dataframe related to the current species input as a
dataframe with the following structure:
\itemize{
\item{material}{Material information. Must include the following:
"Cortex", "Medullary"}
\item{density}{Density of each material (kg/m^3)}
}}

\item{dat_feat_curr}{Dataframe related to the current bird wing feathers
input as a dataframe with the following structure:
\itemize{
\item{feather}{Feather ID code. Must be in standard format i.e.
1st primary is "P1", third secondary is "S3", etc.
Alula feathers should be grouped and named "alula".}
\item{m_f}{Mass of feather in the same row as the
appropriate feather ID code (kg)}
\item{l_cal}{Length of calamus in the same row as the
appropriate feather ID code (m)}
\item{l_vane}{Length of rachis/vane in the same row as the
appropriate feather ID code (m)}
\item{w_cal}{Width (diameter) of calamus in the same row as the
appropriate feather ID code (m)}
\item{w_vp}{Width of proximal vane (average value) in the same row as the
appropriate feather ID code (m)}
\item{w_vd}{Width of distal vane (average value)  in the same row as the
appropriate feather ID code (m)}
\item{vane_angle}{Interior angle between the rachis and calamus  (degrees)}
}
NOTE: Alula feathers will be treated as point mass so only the mass of the
feathers is required. Other columns can be left blank.}

\item{dat_bird_curr}{Dataframe related to the current bird wing that must
include the following columns:
\itemize{
\item{barb_radius}{Radius of feather barb  for current species (m)}
\item{barb_distance}{Distance between feather barbs for current species (m)}
}}
}
\value{
A list with one entry per flight feather. Each primary feather includes the following variables:
\itemize{
\item{I_pri}{a 3x3 matrix representing the moment of inertia about each feather calamus tip (kg-m^2).}
\item{CG_pri}{a 1x3 vector (x,y,z) representing the center of gravity of the primary feather (m).}
\item{m_pri}{a double representing the mass of the primary feather (kg).}
}
Each secondary feather includes the following variables:
\itemize{
\item{I_sec}{a 3x3 matrix representing the moment of inertia about each feather calamus tip (kg-m^2).}
\item{CG_sec}{a 1x3 vector (x,y,z) representing the center of gravity of the primary feather (m).}
\item{m_sec}{a double representing the mass of the primary feather (kg).}
}
}
\description{
Compute the inertia of the individual feathers
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
