% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertiafunctions.R
\name{calc_inertia_platetri}
\alias{calc_inertia_platetri}
\title{Moment of inertia tensor of a flat triangular plate}
\usage{
calc_inertia_platetri(pts, A, rho, t, desired_prop)
}
\arguments{
\item{pts}{a matrix of the three 3D points that define a point on
the triangular plate.
Frame of reference: Muscle | Origin: VRP
each point should be a different row as follows:
pt1x, pt1y, pt1z
pt2x, pt1y, pt2z
pt3x, pt3y, pt3z}

\item{A}{area of the triangular plate (m)}

\item{rho}{density of the material (kg/m^3)}

\item{t}{thickness of the plate (m)}

\item{desired_prop}{a string containing either "I" or "CG" depending on the
desired output}
}
\value{
a 3x3 matrix representing the moment of inertia tensor of a flat
triangular plate about
its center of gravity. Z axis defined as the normal to the input points.
}
\description{
Reference: https://apps.dtic.mil/dtic/tr/fulltext/u2/a183444.pdf
page 4 equations 2.16-2.20
}
\section{Warning}{

The input points should be defined in a counterclockwise direction around the
plate in the triangular plate frame of reference
i.e. all z components should be equal
}

\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
