% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewer.R
\name{viewerUI}
\alias{viewerUI}
\title{UI Module Function.}
\usage{
viewerUI(id, urn = NULL, token = NULL, viewerType = "header")
}
\arguments{
\item{id}{A string. A namespace for the module.}

\item{urn}{A string. Source URN (objectId) for the file. Note the URN must be
Base64 encoded. To encode the URN, see, for example, the
\code{jsonlite::base64_enc} function.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{data:read} scope.}

\item{viewerType}{A string. The type of viewer to instantiate. Either
"header" for the default viewer or "headless" for a viewer without toolbar
or panels.}
}
\description{
UI Module Function.
}
\examples{
\dontrun{
ui <- function(request) {
 shiny::fluidPage(
   viewerUI("pg", myEncodedUrn, myToken)
 )
}
server <- function(input, output, session) {
}
shiny::shinyApp(ui, server)
}
}
\seealso{
\url{https://developer.autodesk.com/en/docs/viewer/v2/overview/}
}

