% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bartlett.R
\name{BartlettTest}
\alias{BartlettTest}
\title{Bartlett's Test for Homogeneity of Variances (Manual Implementation)}
\usage{
BartlettTest(formula, data, alpha = 0.05)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}, where \code{y} is a numeric response
and \code{group} is a factor indicating group membership.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{alpha}{Significance level for the test (default is 0.05).}
}
\value{
An object of class \code{"homocedasticidad"}, containing:
\itemize{
  \item \code{Statistic}: Bartlett's chi-squared test statistic.
  \item \code{df}: Degrees of freedom associated with the test.
  \item \code{p_value}: The p-value for the test statistic.
  \item \code{Decision}: A character string indicating the conclusion ("Heterocedastic" or "Homocedastic").
  \item \code{Method}: A character string indicating the method used ("Bartlett").
}
}
\description{
Conducts Bartlett's test to evaluate whether multiple groups have equal variances,
based on a formula interface and raw data vectors, without requiring a fitted model.
This implementation provides flexibility for exploratory variance testing in custom workflows.
}
\details{
Bartlett’s test is appropriate when group distributions are approximately normal.
It tests the null hypothesis that all groups have equal variances (homoscedasticity).

Advantages:
- Straightforward to compute.
- High sensitivity to variance differences under normality.

Disadvantages:
- Highly sensitive to non-normal distributions.
- Less robust than alternatives like Levene’s test for skewed or heavy-tailed data.
}
\examples{
data(d_e, package = "Analitica")
res <- BartlettTest(Sueldo_actual ~ labor, data = d_e)
summary(res)

summary(BartlettTest(Sueldo_actual ~ as.factor(labor), data = d_e))


}
\references{
Bartlett, M. S. (1937). "Properties of sufficiency and statistical tests." \emph{Proceedings of the Royal Society of London}, Series A, 160(901), 268–282.
}
