% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brown_ForsythTest.R
\name{BrownForsytheTest}
\alias{BrownForsytheTest}
\title{Brown-Forsythe Test for Homogeneity of Variances (Manual Implementation)}
\usage{
BrownForsytheTest(formula, data, alpha = 0.05)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}, where \code{y} is numeric
and \code{group} is a factor.}

\item{data}{A data frame containing the variables.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"homocedasticidad"}, with:
\itemize{
  \item \code{Statistic}: F-statistic.
  \item \code{df1}: Numerator degrees of freedom.
  \item \code{df2}: Denominator degrees of freedom.
  \item \code{p_value}: P-value.
  \item \code{Decision}: "Heterocedastic" or "Homocedastic".
  \item \code{Method}: "Brown-Forsythe".
}
}
\description{
Performs the Brown-Forsythe test using absolute deviations from the median
of each group, followed by a one-way ANOVA on those deviations.
}
\details{
This test is a robust alternative to Bartlett's test, especially useful when
the assumption of normality is violated or when outliers are present.

Advantages:
- More robust than Bartlett's test under non-normal distributions.
- Less sensitive to outliers due to the use of the median.

Disadvantages:
- Lower power than Bartlett's test when normality strictly holds.
- Assumes that absolute deviations follow similar distributions across groups.
}
\examples{
data(d_e, package = "Analitica")
res <- BrownForsytheTest(Sueldo_actual ~ labor, data = d_e)
summary(res)


}
\references{
Brown, M. B., & Forsythe, A. B. (1974). "Robust Tests for the Equality of Variances".
\emph{Journal of the American Statistical Association}, 69(346), 364–367.
}
