technical_indicator_specification <- list(
  
  
  time_series_intraday         = list(required = c("symbol", "interval"), optional = c("outputsize", "datatype")),
  time_series_daily            = list(required = c("symbol"), optional = c("outputsize", "datatype")),
  time_series_daily_adjusted   = list(required = c("symbol"), optional = c("outputsize", "datatype")),
  time_series_weekly           = list(required = c("symbol"), optional = c("datatype")),
  time_series_monthly          = list(required = c("symbol"), optional = c("datatype")),
  
  
  
  sma           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  ema           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  wma           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  dema          = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  tema          = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  trima         = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  kama          = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  mama          = list(required = c("symbol", "interval", "series_type"), optional = c("fastlimit", "slowlimit")),
  t3            = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  macd          = list(required = c("symbol", "interval", "series_type"), optional = c("fastperiod", "slowperiod", "signalperiod")),
  macdext       = list(required = c("symbol", "interval", "series_type"), optional = c("fastperiod", "slowperiod", "signalperiod", "fastmatype", "slowmatype", "signalmatype")),
  stoch         = list(required = c("symbol", "interval"), optional = c("fastkperiod", "slowkperiod", "slowdperiod", "slowkmatype", "slowdmatype")),
  stochf        = list(required = c("symbol", "interval"), optional = c("fastkperiod", "fastdperiod", "fastdmatype")),
  rsi           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  stochrsi      = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c("fastkperiod", "fastdperiod", "fastdmatype")),
  willr         = list(required = c("symbol", "interval", "time_period"), optional = c()),
  adx           = list(required = c("symbol", "interval", "time_period"), optional = c()),
  adxr          = list(required = c("symbol", "interval", "time_period"), optional = c()),
  apo           = list(required = c("symbol", "interval", "series_type"), optional = c("fastperiod", "slowperiod", "matype")),
  ppo           = list(required = c("symbol", "interval", "series_type"), optional = c("fastperiod", "slowperiod", "matype")),
  mom           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  cci           = list(required = c("symbol", "interval", "time_period"), optional = c()),
  cmo           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  roc           = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  rocr          = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  aroon         = list(required = c("symbol", "interval", "time_period"), optional = c()),
  aroonosc      = list(required = c("symbol", "interval", "time_period"), optional = c()),
  mfi           = list(required = c("symbol", "interval", "time_period"), optional = c()),
  trix          = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  ultosc        = list(required = c("symbol", "interval"), optional = c("timeperiod1", "timeperiod2", "timeperiod3")),
  dx            = list(required = c("symbol", "interval", "time_period"), optional = c()),
  minus_di      = list(required = c("symbol", "interval", "time_period"), optional = c()),
  plus_di       = list(required = c("symbol", "interval", "time_period"), optional = c()),
  minus_dm      = list(required = c("symbol", "interval", "time_period"), optional = c()),
  plus_dm       = list(required = c("symbol", "interval", "time_period"), optional = c()),
  bbands        = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c("nbdevup", "nbdevdn", "matype")),
  midpoint      = list(required = c("symbol", "interval", "time_period", "series_type"), optional = c()),
  midprice      = list(required = c("symbol", "interval", "time_period"), optional = c()),
  sar           = list(required = c("symbol", "interval"), optional = c("acceleration", "maximum")),
  atr           = list(required = c("symbol", "interval", "time_period"), optional = c()),
  natr          = list(required = c("symbol", "interval", "time_period"), optional = c()),
  adosc         = list(required = c("symbol", "interval"), optional = c("fastperiod", "slowperiod")),
  ht_trendline  = list(required = c("symbol", "interval", "series_type"), optional = c()),
  ht_sine       = list(required = c("symbol", "interval", "series_type"), optional = c()),
  ht_trendmode  = list(required = c("symbol", "interval", "series_type"), optional = c()),
  ht_dcperiod   = list(required = c("symbol", "interval", "series_type"), optional = c()),
  ht_dcphase    = list(required = c("symbol", "interval", "series_type"), optional = c()),
  ht_phasor     = list(required = c("symbol", "interval", "series_type"), optional = c()),
  
  sector = list(required = c(), optional = c())
)


