% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaSimR.R
\docType{package}
\name{AlphaSimR-package}
\alias{AlphaSimR}
\alias{AlphaSimR-package}
\title{AlphaSimR: Breeding Program Simulations}
\description{
The successor to the 'AlphaSim' software for breeding program 
simulation [Faux et al. (2016) <doi:10.3835/plantgenome2016.02.0013>]. 
Used for stochastic simulations of breeding programs to the level of DNA 
sequence for every individual. Contained is a wide range of functions for 
modeling common tasks in a breeding program, such as selection and crossing. 
These functions allow for constructing simulations of highly complex plant and 
animal breeding programs via scripting in the R software environment. Such 
simulations can be used to evaluate overall breeding program performance and 
conduct research into breeding program design, such as implementation of 
genomic selection. Included is the 'Markovian Coalescent Simulator' ('MaCS') 
for fast simulation of biallelic sequences according to a population 
demographic history [Chen et al. (2009) <doi:10.1101/gr.083634.108>].

Please see the introductory vignette for instructions for using this package. 
The vignette can be viewed using the following command: 
\code{vignette("intro",package="AlphaSimR")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/gaynorr/AlphaSimR}
}

}
\author{
\strong{Maintainer}: Chris Gaynor \email{gaynor.robert@hotmail.com} (\href{https://orcid.org/0000-0003-0558-6656}{ORCID})

Other contributors:
\itemize{
  \item Gregor Gorjanc (\href{https://orcid.org/0000-0001-8008-2787}{ORCID}) [contributor]
  \item John Hickey (\href{https://orcid.org/0000-0001-5675-3974}{ORCID}) [contributor]
  \item Daniel Money (\href{https://orcid.org/0000-0001-5151-3648}{ORCID}) [contributor]
  \item David Wilson [contributor]
  \item Thiago Oliveira (\href{https://orcid.org/0000-0002-4555-2584}{ORCID}) [contributor]
}

}
\keyword{internal}
