% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_dailyStatistic.R
\name{monitor_dailyStatistic}
\alias{monitor_dailyStatistic}
\title{Create daily statistics for each monitor in an \emph{mts_monitor} object}
\usage{
monitor_dailyStatistic(
  monitor = NULL,
  FUN = mean,
  na.rm = TRUE,
  minHours = 18,
  dayBoundary = c("clock", "LST"),
  ...
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{FUN}{Function used to create daily statistics.}

\item{na.rm}{Value passed on to \code{FUN}. If \code{FUN} does not use
\code{na.rm}, this should be set to \code{NULL}.}

\item{minHours}{Minimum number of valid hourly records per day required to
calculate statistics. Days with fewer valid records will be assigned \code{NA}.}

\item{dayBoundary}{Treatment of daylight savings time:  "clock" uses daylight
savings time as defined in the local timezone, "LST" uses "local standard time"
all year round.}

\item{...}{Additional arguments to be passed to \code{FUN}.}
}
\value{
A \emph{mts_monitor} object containing daily statistical summaries. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Daily statstics are calculated for each time series in \code{monitor$data}
using \code{FUN} and any arguments passed in \code{...}.

Because the returned \emph{mts_monitor} object is defined on a daily axis in a
specific time zone, it is important that the incoming \code{monitor} contain
timeseries associated with a single time zone.
}
\note{
When \code{dayBoundary = "clock"}, the returned \code{monitor$data$datetime}
time axis will be defined in the local timezone (not "UTC") with days defined
by midnight as it appears on a clock in that timezone. The transition from
DST to standard time will result in a 23 hour day and standard to DST in a
25 hour day.

When \code{dayBoundary = "LST"}, the returned \code{monitor$data$datetime}
time axis will be defined in "UTC" with times as they \emph{appear} in standard
time in the local timezone. These days will be one hour off from clock
time during DST but every day will consist of 24 hours.
}
\examples{
library(AirMonitor)

Carmel_Valley \%>\%
  monitor_dailyStatistic(max) \%>\%
  monitor_getData()

Carmel_Valley \%>\%
  monitor_dailyStatistic(min) \%>\%
  monitor_getData()
}
