% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa_aqs_loadAnnual.R
\name{epa_aqs_loadAnnual}
\alias{epa_aqs_loadAnnual}
\title{Load annual AirNow monitoring data}
\usage{
epa_aqs_loadAnnual(
  year = NULL,
  archiveBaseUrl = paste0("https://airfire-data-exports.s3.us-west-2.amazonaws.com/",
    "monitoring/v2"),
  archiveBaseDir = NULL,
  QC_negativeValues = c("zero", "na", "ignore"),
  parameterCode = c("PM2.5", "88101", "88502")
)
}
\arguments{
\item{year}{Year [YYYY].}

\item{archiveBaseUrl}{Base URL for monitoring v2 data files.}

\item{archiveBaseDir}{Local base directory for monitoring v2 data files.}

\item{QC_negativeValues}{Type of QC to apply to negative values.}

\item{parameterCode}{One of the EPA AQS criteria parameter codes.}
}
\value{
A \emph{mts_monitor} object with EPA AQS data. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Loads pre-generated .rda files containing hourly AirNow data.

If \code{archiveDataDir} is defined, data will be loaded from this local
archive. Otherwise, data will be loaded from the monitoring data repository
maintained by the USFS AirFire team.

The files loaded by this function contain a single year's worth of data.

Pre-processed AirNow exists for the following parameter codes:
\enumerate{
\item{88101 -- PM2.5 FRM/FEM Mass}
\item{88502 -- PM2.5 non FRM/FEM Mass}
}

Specifying \code{parameterCode = "PM2.5"} will merge records from both
sources.
}
\examples{
\dontrun{
library(AirMonitor)

# Fail gracefully if any resources are not available
try({

# See https://en.wikipedia.org/wiki/2017_Montana_wildfires

# Daily Barplot of Montana wildfires
epa_aqs_loadAnnual(2015) \\%>\\%
  monitor_filter(stateCode == "WA") \\%>\\%
  monitor_filterDate(20150724, 20150907) \\%>\\%
  monitor_dailyStatistic() \\%>\\%
  monitor_timeseriesPlot(
    main = "Washington 2015 -- AirNow Daily Average PM2.5"
  )

}, silent = FALSE)
}
}
