% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_loadLatest.R
\name{airsis_loadLatest}
\alias{airsis_loadLatest}
\title{Load most recent AIRSIS monitoring data}
\usage{
airsis_loadLatest(
  archiveBaseUrl = paste0("https://airfire-data-exports.s3.us-west-2.amazonaws.com/",
    "monitoring/v2"),
  archiveBaseDir = NULL,
  QC_negativeValues = c("zero", "na", "ignore")
)
}
\arguments{
\item{archiveBaseUrl}{Base URL for monitoring v2 data files.}

\item{archiveBaseDir}{Local base directory for monitoring v2 data files.}

\item{QC_negativeValues}{Type of QC to apply to negative values.}
}
\value{
A \emph{mts_monitor} object with AIRSIS data. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Loads pre-generated .rda files containing the most recent
AIRSIS data.

If \code{archiveDataDir} is defined, data will be loaded from this local
archive. Otherwise, data will be loaded from the monitoring data repository
maintained by the USFS AirFire team.

The files loaded by this function are updated multiple times an hour and
contain data for the previous 10 days.

For daily updates covering the most recent 45 days, use \code{airsis_loadDaily()}.

For data extended more than 45 days into the past, use \code{airsis_loadAnnual()}.
}
\examples{
\dontrun{
library(AirMonitor)

# Fail gracefully if any resources are not available
try({

airsis_loadLatest()\ \%>\\%
  monitor_filter(stateCode == "CA") \\%>\\%
  monitor_leaflet()

}, silent = FALSE)
}
}
\seealso{
\code{\link{airsis_loadAnnual}}

\code{\link{airsis_loadDaily}}
}
