% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_analysis.R
\name{correlation}
\alias{correlation}
\title{Graph: Plot correlation}
\usage{
correlation(
  x,
  y,
  method = "pearson",
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  textsize = 12,
  pointsize = 5,
  pointshape = 21,
  linesize = 0.8,
  fill.ic = "gray70",
  alpha.ic = 0.5,
  ic = TRUE,
  title = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{x}{Numeric vector with independent variable}

\item{y}{Numeric vector with dependent variable}

\item{method}{Method correlation (\emph{default} is Pearson)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{textsize}{Axis text size}

\item{pointsize}{Point size}

\item{pointshape}{shape format}

\item{linesize}{line size}

\item{fill.ic}{Color interval of confidence}

\item{alpha.ic}{confidence interval transparency level}

\item{ic}{Add interval of confidence}

\item{title}{title}

\item{fontfamily}{Font family}
}
\value{
The function returns a graph for correlation
}
\description{
Correlation analysis function (Pearson or Spearman)
}
\examples{
data("aristolochia")
with(aristolochia, correlation(trat,resp))
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves
}
