% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorentz_analysis.R
\name{lorentz}
\alias{lorentz}
\title{Analysis: Lorentz}
\usage{
lorentz(
  trat,
  resp,
  npar = "lo3",
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  error = "SE",
  legend.position = "top",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{npar}{number of parameters (lo3 or lo4)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
Analysis: Lorentz
}
\details{
The model to the three-parameter Lorentz is:
\deqn{y = frac{d}{1+b(x-e)^2}}
The model to the three-parameter Lorentz is:
\deqn{y = c+frac{d-c}{1+b(x-e)^2}}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
x=time[length(time):1]
lorentz(x,WL)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley & Sons (p. 330).

Onofri A. (2020) The broken bridge between biologists and statisticians: a blog and R package, Statforbiology, IT, web: https://www.statforbiology.com
}
\author{
Model imported from the aomisc package (Onofri, 2020)

Gabriel Danilo Shimizu
}
