% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_analysis.R
\name{GP}
\alias{GP}
\title{Analysis: Logistic regression Gompertz models}
\usage{
GP(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  error = "SE",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  comment = NA
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{comment}{Add text after equation}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
The logistical models provide Gompertz modified logistical models. This model was extracted from the 'drc' package.
}
\details{
The Gompertz model is given by the mean function:
\deqn{f(x) = c + (d-c)(exp^{-exp^{b(x-e)}})}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
GP(trat,resp)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley \& Sons (p. 330).

Ritz, C.; STREBIG, J.C. and RITZ, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\seealso{
\link{LL}, \link{CD}, \link{BC}
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
