% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\docType{class}
\name{ASSISTDesignC}
\alias{ASSISTDesignC}
\title{A fixed sample RCT design to compare against the adaptive clinical trial design of Lai, Lavori and Liao.}
\format{An \code{\link{R6Class}} generator object}
\usage{
# design <- ASSISTDesignC$new(trialParameters, designParameters)
}
\description{
\code{ASSISTDesignC} objects are used to design a trial with certain
characteristics provided in the object instantiation method. This design differs from
\code{ASSISTDesign} in only how it computes the critical boundaries, how it performs the interim look,
and what quantities are computed in a trial run.
}
\section{Methods}{


\describe{
\item{\code{ASSISTDesignC$new(designParameters, trialParameters, discreteData = FALSE, boundaries)}}{Create a new
\code{ASSISTDesign} instance object using the parameters specified. If \code{discreteData} is \code{TRUE} use a discrete distribution for the Rankin scores and \code{designParameters} must contain the appropriate distributions to sample from. If `boundaries is specified, it is used.}
\item{\code{getDesignameters},\code{getTrialParameters},
\code{getBoundaries}}{Accessor methods for (obvious) object slots}
\item{\code{setBoundaries}}{Modifier method for boundaries a
named vector of double values with names \code{btilde},
\code{b}, and \code{c}, in that order}
\item{\code{print()}}{Print the object in a human readable form}
\item{\code{computeCriticalValues()}}{Compute the critical boundary value \eqn{c_\alpha}}
\item{\code{explore(numberOfSimulations = 5000, rngSeed = 12345}}{Explore the design
using the specified number of simulations and random number seed. There are further parameters. By default \code{trueParameters = self$getDesignParameters()} as would be the case for a Type I error calculation. If changed, would yield power. Also \code{showProgress = TRUE/FALSE}, \code{saveRawData = TRUE/FALSE} control raw data saves and display of  progress.  Returns a list of results}
\item{\code{analyze(trialExploration)}}{Analyze
the design given the \code{trialExploration} which is the result of a call to \code{explore} to
simulate the design. Return a list of summary quantities}
\item{\code{summary(analysis)}}{Print the operating characteristics of the design, using the analysis
result from the \code{analyze} call}
}
}

\examples{
data(LLL.SETTINGS)
prevalence <- LLL.SETTINGS$prevalences$table1
scenario <- LLL.SETTINGS$scenarios$S0
designParameters <- list(prevalence = prevalence,
                       mean = scenario$mean,
                       sd = scenario$sd)
## A realistic design uses 5000 simulations or more!
designC <- ASSISTDesignC$new(trialParameters = LLL.SETTINGS$trialParameters,
                            designParameters = designParameters)
print(designC)
result <- designC$explore(numberOfSimulations = 100, showProgress = interactive())
analysis <- designC$analyze(result)
designC$summary(analysis)
## For full examples, try:
## browseURL(system.file("full_doc/ASSISTant.html", package="ASSISTant"))

}
\references{
Adaptive Choice of Patient Subgroup for Comparing Two Treatments
by Tze Leung Lai and Philip W. Lavori and Olivia Yueh-Wen Liao. Contemporary Clinical Trials,
Vol. 39, No. 2, pp 191-200 (2014). doi:10.1016/j.cct.2014.09.001g
}
\seealso{
\code{ASSISTDesignB} which is a superclass of this object
}
\keyword{datasets}
