% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arvi.R
\name{arvi}
\alias{arvi}
\title{Atmospherically Resistant Vegetation Index}
\usage{
arvi(directory = getwd(), crop = "n", ext2crop = "none", gamma = 1)
}
\arguments{
\item{directory}{Path to Satellite image folder. Assign as string (inside double quotes).
Either assing inside function or set up satellite image folder as the current working directory
before running the function.
To define current working directory, either use shortcut key Ctrl+Shift+H  or use \code{\link{setwd}} funtion.}

\item{crop}{Defines the method of cropping outputs to custom extent.

"n" <- No cropping required (Default).

"u" <- Satellite image will be plotted in the plot window and user can choose the extent by clicking on the top left maximum followed by bottom right maximum.

"y" <- Crop to the maximum and minimum extent of the shapefile.

"f" <- Crop to exact shapefile boundary.}

\item{ext2crop}{Path to the shapefile (*.shp) which will be used for cropping. Shapefile should have SAME CORDINATE SYSTEM as the satellite image.
Either provide the full path of .shp file or provide the name of the shapefile variable which is already open.}

\item{gamma}{It is an aerosol dependant factor. For more details please refer Kaufman and Tanre (1992). By default the value is 1.}
}
\value{
File named "arvi_'date of satellite image acqisition'.tif" in the input folder.
}
\description{
Atmospherically Resistant Vegetation Index (ARVI) is a vegetation based index which
minimizes the effects of atmospheric scattering in comparison to NDVI.
}
\note{
1. ARVI = (r_nir - rb)/(r_nir + rb), where

rb = r_red - gamma (r_blue - r_red)'  and "r_" denotes Top Of Atmoshpere (TOA) reflection, 'gamma' value is 1 by default as recommended if information about the aerosol type is not available.
Please refer Kaufman and Tanre (1992) for more details.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
arvi (directory = path, crop = "y", ext2crop = shapefil)
}
\references{
\href{http://ieeexplore.ieee.org/document/134076/?arnumber=134076&tag=1}{Kaufman, Y. J. and D. Tanre (1992) Atmospherically resistant vegetation index (ARVI) for EOS-MODIS, IEEE Transactions on Geoscience and Remote Sensing, 30 (2). doi:10.1109/36.134076.}
}
