% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ElkinAB}
\alias{ElkinAB}
\title{Synthetic 2x2 Within-Subjects Experiment}
\format{
A data frame with 32 observations on the following 4 variables.
\describe{
     \item{S}{a factor representing subjects with levels \code{"s1"} .. \code{"s8"}}
     \item{A}{a factor with levels \code{"a1"} \code{"a2"}}
     \item{B}{a factor with levels \code{"b1"} \code{"b2"}}
     \item{Y}{a numeric vector}
}
}
\source{
Elkin, L. A., Kay, M, Higgins, J. J., and Wobbrock, J. O.
  (2021). An Aligned Rank Transform Procedure for Multifactor Contrast Tests.
  \href{https://arxiv.org/abs/2102.11824}{arXiv eprint: 2102.11824}.
}
\description{
Synthetic data from an experiment with two within-subjects factors
(\code{A} and \code{B}) having two levels each.
}
\examples{
\donttest{
data(ElkinAB, package = "ARTool")

## run contrast using the ART-C procedure on the data.
m <- art(Y ~ A*B + (1|S), data = ElkinAB)
art.con(m, "A:B")
}
}
\keyword{datasets}
