% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ARPA_Lombardia_zoning.R
\name{get_ARPA_Lombardia_zoning}
\alias{get_ARPA_Lombardia_zoning}
\title{Download ARPA Lombardia zoning geometries}
\usage{
get_ARPA_Lombardia_zoning(
  plot_map = 1,
  title = "ARPA Lombardia zoning",
  line_type = 1,
  line_size = 1,
  xlab = "Longitude",
  ylab = "Latitude"
)
}
\arguments{
\item{plot_map}{Logic value (0 or 1). If plot_map = 1, the ARPA Lombardia zoning is represented
on a map, if plot_mat = 0 only the geometry (polygon shapefile) is stored in the output.
Default is plot_map = 1.}

\item{title}{Title of the plot. Deafult is 'ARPA Lombardia zoning'}

\item{line_type}{Linetype for the zones' borders. Default is 1.}

\item{line_size}{Size of the line for the zones. Default is 1.}

\item{xlab}{x-axis label. Default is 'Longitude'.}

\item{ylab}{y-axis label. Default is 'Latitude'.}
}
\value{
The function returns an object of class 'sf' containing the polygon borders of the seven zones used by
ARPA Lombardia to classify the regional territory. If plot_map = 1, it also returns a map of the zoning.
}
\description{
'get_ARPA_Lombardia_zoning' returns the geometries (polygonal shape file) and a map of
the ARPA zoning of Lombardy. The zoning reflects the main orographic characteristics of the territory.
Lombardy region is classified into seven type of areas: large urbanized areas, urbanized areas in rural
contexts, rural areas, mountainous areas and valley bottom.
For more information about the municipal data visit the section 'Zonizzazione ARPA Lombardia' at the webpages
https://www.arpalombardia.it/temi-ambientali/aria/rete-di-rilevamento/classificazione-zone/ and
https://www.arpalombardia.it/temi-ambientali/aria/mappa-della-zonizzazione/
}
\examples{
zones <- get_ARPA_Lombardia_zoning(plot_map = 1)

}
