% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_ab_class.R
\name{filter_ab_class}
\alias{filter_ab_class}
\alias{filter_aminoglycosides}
\alias{filter_carbapenems}
\alias{filter_cephalosporins}
\alias{filter_1st_cephalosporins}
\alias{filter_2nd_cephalosporins}
\alias{filter_3rd_cephalosporins}
\alias{filter_4th_cephalosporins}
\alias{filter_5th_cephalosporins}
\alias{filter_fluoroquinolones}
\alias{filter_glycopeptides}
\alias{filter_macrolides}
\alias{filter_tetracyclines}
\title{Filter isolates on result in antibiotic class}
\usage{
filter_ab_class(x, ab_class, result = NULL, scope = "any", ...)

filter_aminoglycosides(x, result = NULL, scope = "any", ...)

filter_carbapenems(x, result = NULL, scope = "any", ...)

filter_cephalosporins(x, result = NULL, scope = "any", ...)

filter_1st_cephalosporins(x, result = NULL, scope = "any", ...)

filter_2nd_cephalosporins(x, result = NULL, scope = "any", ...)

filter_3rd_cephalosporins(x, result = NULL, scope = "any", ...)

filter_4th_cephalosporins(x, result = NULL, scope = "any", ...)

filter_5th_cephalosporins(x, result = NULL, scope = "any", ...)

filter_fluoroquinolones(x, result = NULL, scope = "any", ...)

filter_glycopeptides(x, result = NULL, scope = "any", ...)

filter_macrolides(x, result = NULL, scope = "any", ...)

filter_tetracyclines(x, result = NULL, scope = "any", ...)
}
\arguments{
\item{x}{a data set}

\item{ab_class}{an antimicrobial class, like \code{"carbapenems"}, as can be found in \code{\link[=antibiotics]{antibiotics$group}}}

\item{result}{an antibiotic result: S, I or R (or a combination of more of them)}

\item{scope}{the scope to check which variables to check, can be \code{"any"} (default) or \code{"all"}}

\item{...}{parameters passed on to \code{filter_at} from the \code{dplyr} package}
}
\description{
Filter isolates on results in specific antibiotic variables based on their antibiotic class. This makes it easy to filter on isolates that were tested for e.g. any aminoglycoside.
}
\details{
The \code{group} column in \link{antibiotics} data set will be searched for \code{ab_class} (case-insensitive). If no results are found, the \code{atc_group1} and \code{atc_group2} columns will be searched. Next, \code{x} will be checked for column names with a value in any abbreviations, codes or official names found in the \link{antibiotics} data set.
}
\section{Stable lifecycle}{

\if{html}{\figure{lifecycle_stable.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{stable}. In a stable function, we are largely happy with the unlying code, and major changes are unlikely. This means that the unlying code will generally evolve by adding new arguments; we will avoid removing arguments or changing the meaning of existing arguments.

If the unlying code needs breaking changes, they will occur gradually. To begin with, the function or argument will be deprecated; it will continue to work but will emit an message informing you of the change. Next, typically after at least one newly released version on CRAN, the message will be transformed to an error.
}

\examples{
library(dplyr)

# filter on isolates that have any result for any aminoglycoside
example_isolates \%>\% filter_aminoglycosides()

# this is essentially the same as (but without determination of column names):
example_isolates \%>\%
  filter_at(.vars = vars(c("GEN", "TOB", "AMK", "KAN")),
            .vars_predicate = any_vars(. \%in\% c("S", "I", "R")))


# filter on isolates that show resistance to ANY aminoglycoside
example_isolates \%>\% filter_aminoglycosides("R")

# filter on isolates that show resistance to ALL aminoglycosides
example_isolates \%>\% filter_aminoglycosides("R", "all")

# filter on isolates that show resistance to
# any aminoglycoside and any fluoroquinolone
example_isolates \%>\%
  filter_aminoglycosides("R") \%>\%
  filter_fluoroquinolones("R")

# filter on isolates that show resistance to
# all aminoglycosides and all fluoroquinolones
example_isolates \%>\%
  filter_aminoglycosides("R", "all") \%>\%
  filter_fluoroquinolones("R", "all")
}
