% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atc_online.R
\name{atc_online_property}
\alias{atc_online_property}
\alias{atc_online_groups}
\alias{atc_online_ddd}
\title{Get ATC properties from WHOCC website}
\source{
\url{https://www.whocc.no/atc_ddd_alterations__cumulative/ddd_alterations/abbrevations/}
}
\usage{
atc_online_property(atc_code, property, administration = "O",
  url = "https://www.whocc.no/atc_ddd_index/?code=\%s&showdescription=no")

atc_online_groups(atc_code, ...)

atc_online_ddd(atc_code, ...)
}
\arguments{
\item{atc_code}{a character or character vector with ATC code(s) of antibiotic(s)}

\item{property}{property of an ATC code. Valid values are \code{"ATC"}, \code{"Name"}, \code{"DDD"}, \code{"U"} (\code{"unit"}), \code{"Adm.R"}, \code{"Note"} and \code{groups}. For this last option, all hierarchical groups of an ATC code will be returned, see Examples.}

\item{administration}{type of administration when using \code{property = "Adm.R"}, see Details}

\item{url}{url of website of the WHO. The sign \code{\%s} can be used as a placeholder for ATC codes.}

\item{...}{parameters to pass on to \code{atc_property}}
}
\description{
Gets data from the WHO to determine properties of an ATC (e.g. an antibiotic) like name, defined daily dose (DDD) or standard unit. \cr \strong{This function requires an internet connection.}
}
\details{
Options for parameter \code{administration}:
\itemize{
  \item{\code{"Implant"}}{ = Implant}
  \item{\code{"Inhal"}}{ = Inhalation}
  \item{\code{"Instill"}}{ = Instillation}
  \item{\code{"N"}}{ = nasal}
  \item{\code{"O"}}{ = oral}
  \item{\code{"P"}}{ = parenteral}
  \item{\code{"R"}}{ = rectal}
  \item{\code{"SL"}}{ = sublingual/buccal}
  \item{\code{"TD"}}{ = transdermal}
  \item{\code{"V"}}{ = vaginal}
}

Abbreviations of return values when using \code{property = "U"} (unit):
\itemize{
  \item{\code{"g"}}{ = gram}
  \item{\code{"mg"}}{ = milligram}
  \item{\code{"mcg"}}{ = microgram}
  \item{\code{"U"}}{ = unit}
  \item{\code{"TU"}}{ = thousand units}
  \item{\code{"MU"}}{ = million units}
  \item{\code{"mmol"}}{ = millimole}
  \item{\code{"ml"}}{ = milliliter (e.g. eyedrops)}
}
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
\donttest{
# oral DDD (Defined Daily Dose) of amoxicillin
atc_online_property("J01CA04", "DDD", "O")
# parenteral DDD (Defined Daily Dose) of amoxicillin
atc_online_property("J01CA04", "DDD", "P")

atc_online_property("J01CA04", property = "groups") # search hierarchical groups of amoxicillin
# [1] "ANTIINFECTIVES FOR SYSTEMIC USE"
# [2] "ANTIBACTERIALS FOR SYSTEMIC USE"
# [3] "BETA-LACTAM ANTIBACTERIALS, PENICILLINS"
# [4] "Penicillins with extended spectrum"
}
}
