% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_antibiotics.R
\name{key_antibiotics}
\alias{key_antibiotics}
\alias{key_antibiotics_equal}
\title{Key antibiotics for first \emph{weighted} isolates}
\usage{
key_antibiotics(tbl, col_mo = NULL, universal_1 = guess_ab_col(tbl,
  "amox"), universal_2 = guess_ab_col(tbl, "amcl"),
  universal_3 = guess_ab_col(tbl, "cfur"),
  universal_4 = guess_ab_col(tbl, "pita"),
  universal_5 = guess_ab_col(tbl, "cipr"),
  universal_6 = guess_ab_col(tbl, "trsu"),
  GramPos_1 = guess_ab_col(tbl, "vanc"), GramPos_2 = guess_ab_col(tbl,
  "teic"), GramPos_3 = guess_ab_col(tbl, "tetr"),
  GramPos_4 = guess_ab_col(tbl, "eryt"), GramPos_5 = guess_ab_col(tbl,
  "oxac"), GramPos_6 = guess_ab_col(tbl, "rifa"),
  GramNeg_1 = guess_ab_col(tbl, "gent"), GramNeg_2 = guess_ab_col(tbl,
  "tobr"), GramNeg_3 = guess_ab_col(tbl, "coli"),
  GramNeg_4 = guess_ab_col(tbl, "cfot"), GramNeg_5 = guess_ab_col(tbl,
  "cfta"), GramNeg_6 = guess_ab_col(tbl, "mero"), warnings = TRUE, ...)

key_antibiotics_equal(x, y, type = c("keyantibiotics", "points"),
  ignore_I = TRUE, points_threshold = 2, info = FALSE)
}
\arguments{
\item{tbl}{table with antibiotics coloms, like \code{amox} and \code{amcl}.}

\item{col_mo}{column name of the unique IDs of the microorganisms (see \code{\link{mo}}), defaults to the first column of class \code{mo}. Values will be coerced using \code{\link{as.mo}}.}

\item{universal_1, universal_2, universal_3, universal_4, universal_5, universal_6}{column names of \strong{broad-spectrum} antibiotics, case-insensitive. At default, the columns containing these antibiotics will be guessed with \code{\link{guess_ab_col}}.}

\item{GramPos_1, GramPos_2, GramPos_3, GramPos_4, GramPos_5, GramPos_6}{column names of antibiotics for \strong{Gram positives}, case-insensitive. At default, the columns containing these antibiotics will be guessed with \code{\link{guess_ab_col}}.}

\item{GramNeg_1, GramNeg_2, GramNeg_3, GramNeg_4, GramNeg_5, GramNeg_6}{column names of antibiotics for \strong{Gram negatives}, case-insensitive. At default, the columns containing these antibiotics will be guessed with \code{\link{guess_ab_col}}.}

\item{warnings}{give warning about missing antibiotic columns, they will anyway be ignored}

\item{...}{other parameters passed on to function}

\item{x, y}{characters to compare}

\item{type}{type to determine weighed isolates; can be \code{"keyantibiotics"} or \code{"points"}, see Details}

\item{ignore_I}{logical to determine whether antibiotic interpretations with \code{"I"} will be ignored when \code{type = "keyantibiotics"}, see Details}

\item{points_threshold}{points until the comparison of key antibiotics will lead to inclusion of an isolate when \code{type = "points"}, see Details}

\item{info}{print progress}
}
\description{
These function can be used to determine first isolates (see \code{\link{first_isolate}}). Using key antibiotics to determine first isolates is more reliable than without key antibiotics. These selected isolates will then be called first \emph{weighted} isolates.
}
\details{
The function \code{key_antibiotics} returns a character vector with 12 antibiotic results for every isolate. These isolates can then be compared using \code{key_antibiotics_equal}, to check if two isolates have generally the same antibiogram. Missing and invalid values are replaced with a dot (\code{"."}). The \code{\link{first_isolate}} function only uses this function on the same microbial species from the same patient. Using this, an MRSA will be included after a susceptible \emph{S. aureus} (MSSA) found within the same episode (see \code{episode} parameter of \code{\link{first_isolate}}). Without key antibiotic comparison it would not.

  At default, the antibiotics that are used for \strong{Gram positive bacteria} are (colum names): \cr
  \code{"amox"}, \code{"amcl"}, \code{"cfur"}, \code{"pita"}, \code{"cipr"}, \code{"trsu"} (until here is universal), \code{"vanc"}, \code{"teic"}, \code{"tetr"}, \code{"eryt"}, \code{"oxac"}, \code{"rifa"}.

  At default, the antibiotics that are used for \strong{Gram negative bacteria} are (colum names): \cr
  \code{"amox"}, \code{"amcl"}, \code{"cfur"}, \code{"pita"}, \code{"cipr"}, \code{"trsu"} (until here is universal), \code{"gent"}, \code{"tobr"}, \code{"coli"}, \code{"cfot"}, \code{"cfta"}, \code{"mero"}.


  The function \code{key_antibiotics_equal} checks the characters returned by \code{key_antibiotics} for equality, and returns a logical vector.
}
\section{Key antibiotics}{

    There are two ways to determine whether isolates can be included as first \emph{weighted} isolates which will give generally the same results: \cr

    \strong{1. Using} \code{type = "keyantibiotics"} \strong{and parameter} \code{ignore_I} \cr
    Any difference from S to R (or vice versa) will (re)select an isolate as a first weighted isolate. With \code{ignore_I = FALSE}, also differences from I to S|R (or vice versa) will lead to this. This is a reliable method and 30-35 times faster than method 2. \cr

    \strong{2. Using} \code{type = "points"} \strong{and parameter} \code{points_threshold} \cr
    A difference from I to S|R (or vice versa) means 0.5 points, a difference from S to R (or vice versa) means 1 point. When the sum of points exceeds \code{points_threshold}, an isolate will be (re)selected as a first weighted isolate.
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# septic_patients is a dataset available in the AMR package
?septic_patients
library(dplyr)
# set key antibiotics to a new variable
my_patients <- septic_patients \%>\%
  mutate(keyab = key_antibiotics(.)) \%>\%
  mutate(
    # now calculate first isolates
    first_regular = first_isolate(., col_keyantibiotics = FALSE),
    # and first WEIGHTED isolates
    first_weighted = first_isolate(., col_keyantibiotics = "keyab")
  )

# Check the difference, in this data set it results in 7\% more isolates:
sum(my_patients$first_regular, na.rm = TRUE)
sum(my_patients$first_weighted, na.rm = TRUE)


# output of the `key_antibiotics` function could be like this:
strainA <- "SSSRR.S.R..S"
strainB <- "SSSIRSSSRSSS"

key_antibiotics_equal(strainA, strainB)
# TRUE, because I is ignored (as well as missing values)

key_antibiotics_equal(strainA, strainB, ignore_I = FALSE)
# FALSE, because I is not ignored and so the 4th value differs
}
\seealso{
\code{\link{first_isolate}}
}
