% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_ab_col.R
\name{guess_ab_col}
\alias{guess_ab_col}
\title{Guess antibiotic column}
\usage{
guess_ab_col(tbl = NULL, col = NULL, verbose = FALSE)
}
\arguments{
\item{tbl}{a \code{data.frame}}

\item{col}{a character to look for}

\item{verbose}{a logical to indicate whether additional info should be printed}
}
\description{
This tries to find a column name in a data set based on information from the \code{\link{antibiotics}} data set. Also supports WHONET abbreviations. You can look for an antibiotic (trade) name or abbreviation and it will search the \code{data.frame} for any column containing a name or ATC code of that antibiotic.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
df <- data.frame(amox = "S",
                 tetr = "R")

guess_ab_col(df, "amoxicillin")
# [1] "amox"
guess_ab_col(df, "J01AA07") # ATC code of Tetracycline
# [1] "tetr"

guess_ab_col(df, "J01AA07", verbose = TRUE)
# using column `tetr` for col "J01AA07"
# [1] "tetr"

# WHONET codes
df <- data.frame(AMP_ND10 = "R",
                 AMC_ED20 = "S")
guess_ab_col(df, "ampicillin")
# [1] "AMP_ND10"
guess_ab_col(df, "J01CR02")
# [1] "AMC_ED20"
guess_ab_col(df, as.atc("augmentin"))
# [1] "AMC_ED20"
}
