% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{antibiotics}
\alias{antibiotics}
\title{Dataset with 420 antibiotics}
\format{A data.frame with 420 observations and 18 variables:
\describe{
  \item{\code{atc}}{ATC code, like \code{J01CR02}}
  \item{\code{molis}}{MOLIS code, like \code{amcl}}
  \item{\code{umcg}}{UMCG code, like \code{AMCL}}
  \item{\code{abbr}}{Abbreviation as used by many countries, to be used for \code{\link{guess_atc}}}
  \item{\code{official}}{Official name by the WHO, like \code{"Amoxicillin and enzyme inhibitor"}}
  \item{\code{official_nl}}{Official name in the Netherlands, like \code{"Amoxicilline met enzymremmer"}}
  \item{\code{trivial_nl}}{Trivial name in Dutch, like \code{"Amoxicilline/clavulaanzuur"}}
  \item{\code{trade_name}}{Trade name as used by many countries, to be used for \code{\link{guess_atc}}}
  \item{\code{oral_ddd}}{Defined Daily Dose (DDD), oral treatment}
  \item{\code{oral_units}}{Units of \code{ddd_units}}
  \item{\code{iv_ddd}}{Defined Daily Dose (DDD), parenteral treatment}
  \item{\code{iv_units}}{Units of \code{iv_ddd}}
  \item{\code{atc_group1}}{ATC group, like \code{"Macrolides, lincosamides and streptogramins"}}
  \item{\code{atc_group2}}{Subgroup of \code{atc_group1}, like \code{"Macrolides"}}
  \item{\code{atc_group1_nl}}{ATC group in Dutch, like \code{"Macroliden, lincosamiden en streptograminen"}}
  \item{\code{atc_group2_nl}}{Subgroup of \code{atc_group1} in Dutch, like \code{"Macroliden"}}
  \item{\code{useful_gramnegative}}{\code{FALSE} if not useful according to EUCAST, \code{NA} otherwise (see Source)}
  \item{\code{useful_grampositive}}{\code{FALSE} if not useful according to EUCAST, \code{NA} otherwise (see Source)}
}}
\source{
- World Health Organization: \url{https://www.whocc.no/atc_ddd_index/} \cr - EUCAST - Expert rules intrinsic exceptional V3.1 \cr - MOLIS (LIS of Certe): \url{https://www.certe.nl} \cr - GLIMS (LIS of UMCG): \url{https://www.umcg.nl}
}
\usage{
antibiotics
}
\description{
A dataset containing all antibiotics with a J0 code, with their DDD's. Properties were downloaded from the WHO, see Source.
}
\seealso{
\code{\link{microorganisms}}
}
\keyword{datasets}
